function [data_out] = prepost_prob(dir_tmp,imgvol,ctrs,syn)
%This function based off of join_verts and dhist3 is used to calculate the
%presynaptic and postsynaptic probablity of a directory of rotated flat
%pivots
%Synatax:   [data] = prepost_prob([],[x y z]);
%Input:     dir_tmp = the directory of interest
%           imgvol = The image volume size in x, y and z.  default = 0
%           ctrs = the array of bin centers
%           syn = the number of synpases for each file in the directory
%Output:    data_out = the probabilities

if nargin==0||isempty(dir_tmp)
    prompt_box('title','Open File Location','prompt1','Select the flatvert lists you want to process','position','center');
    pause(0.25);
    dir_tmp = uigetdir2('','Directory where the files are located');    %get the directory
end
if nargin<2||isempty(imgvol)
    imgvol = 0;   %off
end
if nargin<3||isempty(ctrs)
    ctrs = [100 100];
end

%Now sort through the directory and find the
[filenames,names] = dir_sort(dir_tmp);

if nargin<4
    syn = zeros(1,size(filenames{1},1));
end

file_label = [];    %initialize
data_out = [];
d_data = [];
for j = 1:size(filenames,2) %go through the file sets
    filename_tmp = filenames{j};
    data = [];  %initialize/reset
    for i = 1:size(filename_tmp,1)      %now append the files
        %verti_tmp{i} = single(dlmread([pathname_tmp,filename_tmp{1,i}],','));
        try     %file could be empty
            data = single(dlmread([dir_tmp,filesep,filename_tmp(i,:)],',',1,0));
            [density,zdensity,ndata,gyro,vol,xb,yb] = dhist3_loco(data,ctrs,1,imgvol,[],syn(i));
            %get the probablity graph
            data_p = gyro(1).pplot';
            %each bin is 20nm by 20nm, cut off for pre vs. post is 75nm or 4 bins-where
            %the cleft is.
            post = data_p(25:75,25:53);   %postsyanptic square selection
            [post_sel] = dselect_2dhist(post,20,[26,29]);     %center is the PSD puncta
            post_p = sum(sum(post_sel))/2;
            pre = data_p(25:75,54:79);
            [pre_sel] = dselect_2dhist(pre,20,[26,1]);
            pre_p = sum(sum(pre_sel))/2;
            file_label = vertcat(file_label,{filename_tmp(i,1:end-4)});
            data_out = vertcat(data_out,[pre_p post_p]);
            %now calculate a 1d probability distribution 
            gdata = gyro.raw';
            gvol = gyro.vol';
            postd = gdata(25:50,25:53);
            postv = gvol(25:50,25:53);
            pred = gdata(25:50,54:79);
            prev = gvol(25:50,54:79);
            for k = 1:25,[dtmp,pnum] = dselect_2dhist(postd,k,[25,29],'ring');[vtmp,pnum] = dselect_2dhist(postv,k,[25,29],'ring');post_tmp(k) = (sum(sum(dtmp))/syn)/sum(sum(vtmp));end    %post synaptic
            for k = 1:25,[dtmp,pnum] = dselect_2dhist(pred,k,[25,1],'ring');[vtmp,pnum] = dselect_2dhist(prev,k,[25,1],'ring');pre_tmp(k) = (sum(sum(dtmp))/syn)/sum(sum(vtmp));end   %presynaptic
%             for k = 1:25,[ptemp,pnum] = dselect_2dhist(post,k,[26,29],'ring');post_tmp(k) = sum(sum(ptemp))/(pnum);end    %post synaptic
%             for k = 1:25,[ptemp,pnum] = dselect_2dhist(pre,k,[26,1],'ring');pre_tmp(k) = sum(sum(ptemp))/(pnum);end   %presynaptic
            tmp = [fliplr(post_tmp) pre_tmp];   %join pre and post
            d_data = vertcat(d_data,tmp);
        catch
            warning(['There was a problem with processing file: ', filename_tmp]);
        end
    end
end
%prep output data
col_name = {'presynaptic' 'post_synaptic'};
data_sav = dataset({data_out,col_name{:}},'obsnames',file_label);
d_data_sav = dataset(d_data,'obsnames',file_label);
%save data
mkdir(dir_tmp,'prepost_prob');
sav2csv(data_sav,['prepost_probabilities',datestr(now,'yyyymmdd.HHMM'),'.csv'],[dir_tmp,filesep,'prepost_prob']);
sav2csv(d_data_sav,['2d_probabilities',datestr(now,'yyyymmdd.HHMM'),'.csv'],[dir_tmp,filesep,'prepost_prob']);


%-----------------------------------------------------------------------------------------------------------------------------
function [filenames_out,uq_names] = dir_sort(dir_tmp)
%give the directory and it will sort out the files in it and put a cell
%array of filenames
dir_struct = dir(dir_tmp);  %grab the directory information
idx = [dir_struct.isdir];   %grab all of the isdir numbers
names = {dir_struct.name};   %grab the all of the names in the root
filenames = names(~idx);
%filename_tmp = filename_tmp(3:end,:);
for i = 1:size(filenames,2)      %step through each filename and pull the wanted word
    filename_tmp = filenames{i};
    strmask = isstrprop(filename_tmp,'punct');  %find the punctuations, we only want the last two
    strmask2 = filename_tmp=='&';       %we are going to exempt the & character
    strmask3 = isstrprop(filename_tmp,'wspace');    %included the spaces as well
    strmask = strmask-strmask2+strmask3;     %removed and append
    [x,y] = find(strmask==1);  %get the positions
    %if strcmp('csv',filename_tmp(i,y(end)+1:y(end)+3))  %we only care about the csv files for now.
%     if size(y,2)<=3
%         tmp = filename_tmp(1,y(end-1)+1:y(end)-1);    %create an array of the words
%         %now lets consider the vertices case
%         if ~isempty(str2num(tmp))   %not empty = numbers or vertices file, push forward one and go
%             tmp = filename_tmp(1,y(end-2)+1:y(end-1)-1);    %create an array of the words
%         end
%         f_tmp{i,:} = tmp;
%     else    %too complicated take the whole thing
%         tmp = filename_tmp(1,y(end-1)+1:y(end)-1);    %create an array of the words
%         %now lets consider the vertices case
%         if ~isempty(str2num(tmp))   %not empty = numbers or vertices file, push forward one and go
%             tmp = filename_tmp(1,y(1)+1:y(end-1)-1);    %create an array of the words
%         else    %not vertices file or no numbers at very end
%             tmp = filename_tmp(1,y(1)+1:y(end)-1);
%         end
%         f_tmp{i,:} = tmp;
%     end
    %end
    a = 1;  %initiate
    b = 0;
    tmp = filename_tmp(1,y(end-a)+1:y(end-b)-1);    %create an array of the words
    while ~isempty(str2num(tmp))   %not empty = numbers or vertices file, push forward one and go
        a = a+1;
        b = b+1;
        if size(y,2)-a==0
            break
        end
        tmp = filename_tmp(1,y(end-a)+1:y(end-b)-1);    %create an array of the words
    end
    %now do the same for the front
    a = 0;
    tmp = filename_tmp(1,1:y(1+a)-1);
    while ~isempty(str2num(tmp))&&size(y,2)~=a+1   %not empty = numbers or vertices file, push forward one and go
        a = a+1;
        tmp = filename_tmp(1,1:y(1+a)-1);    %create an array of the words
    end
    if a==0
        f_tmp{i,:} = filename_tmp(1,1:y(end-b)-1);
    else
        f_tmp{i,:} = filename_tmp(1,y(a)+1:y(end-b)-1);
    end
end
uq_names = unique(f_tmp);    %how many unique words are there
%make sure there are no duplicates with different cases
idx = [];   %index of removal
for l = 1:size(uq_names,1)      %step through unique names
    for m = 1:size(uq_names,1)     %step through the all file names
        if strcmpi(uq_names(l,:),uq_names(m,:)) && l<m    %if there is a match (case insensitive now) Remove
            idx = [idx;m];  %remove
        end
    end
end 
uq_names(unique(idx),:) = [];    %remove
for j = 1:size(uq_names,1)      %step through unique names
    tmp = [];
    for k = 1:size(f_tmp,1)     %step through the all file names
        if strcmpi(uq_names(j,:),f_tmp(k,:)) %if there is a match (case insensitive now)
            tmp = vertcat(tmp,filenames(k));  %put it in the current file names temp
        end
    end
    filenames_out{j} = char(tmp);
end            
%--------------------------------------------------------------------------
function [density,zdensity,ndata,gyro,vol,xb,yb,c] = dhist3_loco(data,ctrs,bin2px,imgvol,out,syn)
%This function takes a 2D array and creates a 2D density histogram.
%Synatax:   [density,zdensity,ndata,gyro,vol,xb,yb] = dhist3(data,bins,mod,out);
%Input:     ctrs = the bin centers, will also take bin format e.g.[100 100]
%           data = the array to be binned
%           bin2px = the conversion factor for # of bins to a single pixel
%               Default = 1 bin per pixel.
%           imgvol = the image volume.  Used to calculate clipping.  If
%               empty, then assumed no clipping adjustment.  Default = 0,
%               no clipping.
%           out = remove outlier, 5 SD from median., the value you enter,
%               is the number of SD from mean the outliers are.  default  =
%               [].
%Output:    density = a vector of densities equal to bins.
%           zprofile = the z score of each bin
%           rcount = raw count in each bin
%           vol = a vector of volumes equal to bins.
%           xb = the x scale for the 2d hist
%           yb = the y scale for the 2d hist
%           gyro = a structure that contains the raw, volume, density and
%                   plot of the gyro visualization.
%           c = centers of the histogram

if nargin<3||isempty(bin2px)   %defalut
    bin2px = 1;
end
if nargin<4||isempty(imgvol)    %defaults
    imgvol = 0;
end
if nargin<5
    out = [];
end
if nargin<6
    syn = 0;
end

if iscell(ctrs)  %in centers format
    bins(1) = size(ctrs{1},2);
    bins(2) = size(ctrs{2},2);
else    %not in centers format, assume bin format [100 100]
    bins = ctrs;
end

data = unique(data,'rows');     %make sure the data is cleaned of NaNs

[ndata,c] = hist3(data(:,[1 2]),ctrs);    %create the binned data array

xb = linspace(min(data(:,1)),max(data(:,1)),size(ndata,1));       %x scale for the 2d hist
yb = linspace(min(data(:,2)),max(data(:,2)),size(ndata,2));       %y scale for the 2d hist

%now figure out x, y & z to calcuate the volumn cube, rational here is that
%in x, y space the space is the same, only in z is there a volume
%difference.
x = repmat(c{1,1},bins(1),1);      %map the x to the spatial fields
y = repmat(c{1,2}',1,bins(2));     %map the y to the spatial fields
x = vectorize(x);               %vectorize x
y = vectorize(y);               %vectorize y
origin = zeros(size(x,1),2);    %create the origin array, 0,0
z_len = dddist([x y],origin).*bin2px;   %calculate the z length for the array and convert to pixel distance
x_len = abs(c{1,1}(2)-c{1,1}(1));   %calculate the x length for the array, if we are using ctrs, they are already in pixel distances
y_len = abs(c{1,2}(2)-c{1,1}(1));   %calculate the y length for the array
%now convert the length to field arrays
z_len = reshape(z_len,bins(1),bins(2))';
x_len = repmat(x_len,bins(1),bins(2));
y_len = repmat(y_len,bins(1),bins(2));
%now calculate the volume
outer_s = (4/3).*pi.*z_len.^3;  %calculate the outer sphere volume
inner_s = (4/3).*pi.*(z_len-x_len).^3;  %calculate the inner sphere volume 
o_clip = ((pi.*(z_len-y_len/2).^2)/3).*(3*z_len-(z_len-y_len/2))*2;  %calculate the outer clipped region
i_clip = ((pi.*(z_len-x_len-y_len/2).^2)/3).*(3*(z_len-x_len)-(z_len-x_len-y_len/2))*2;     %calcluate the inner clipped region
%the shell sliver volume is the outer sphere volume - clipped region -
%inner sphere volume - clipped region divided by two, because only one
%hemisphere
vol = ((outer_s-o_clip)-(inner_s-i_clip));  %divide by 2 is unnecessary as the volume is already doubled
%if there is an entered image volume normalize for volume
if imgvol
    y_per = normclip(imgvol(1),z_len);  %calculate the percent clipped for y axis
    x_per = normclip(imgvol(2),z_len);  %calculate the percent clipped for x axis
    z_per = normclip(imgvol(3),z_len);  %calculate the percent clipped for z axis
    total_per = y_per+x_per+z_per;  %total amount of clipping for the volume
    %now adjust the vol
    vol = vol-(vol.*total_per);
end

%outlier
if ~isempty(out)
    out_thresh = vectorize(ndata);
    out_thresh(out_thresh==0) = [];
    out_thresh = std(out_thresh)*out;
    %density(density>out_thresh) = out_thresh;
    %we want to smooth our outliers now.
    [ox,oy] = find(ndata>out_thresh);
    for i = 1:size(ox,1)    %step through each outlier and normalize
        ndata(ox(i),oy(i)) = mean(mean(select_vol(ndata,ox(i),oy(i))));
    end
end

%now calculate the density
density = ndata./vol;       %get the density value.

%now calculate the gyro view: new volume combine the sides of the rotations
%then mirror.
r = floor(bins(2)/2)-1;       %calculate the rows to flip: -1 for indexing purposes
r2 = ceil(bins(2)/2);      %forward indexing
right = fliplr(ndata(:,end-r:end));   %get to right half of the data and flip it
rvol = fliplr(vol(:,end-r:end));    %do the same for the volume
if rem(bins(2),2)       %if the divison is not even pad one row
%     right = horzcat(right,zeros(1,bins(1)));
%     rvol = horzcat(rvol,zeros(1,bins(1)));
    %double it instead
    right = horzcat(right,ndata(:,r2));
    rvol = horzcat(rvol,vol(:,r2));
end
gdata = ndata(:,1:r2)+right;   %gyro data
gvol = vol(:,1:r2)+rvol;        %gyro volume
gdensity = gdata./gvol;     %gyro density
gplot = horzcat(gdensity,fliplr(gdensity(:,1:r+1)));  %mirror the graph for plotting
%gprob = gplot./(sum(sum(gplot)));   %calculate the probability plot
%output the gyro data
gyro.raw = gdata;
gyro.vol = gvol;
gyro.density = gdensity;
gyro.plot = gplot;

%calculate statics: z score
%first calculate the mean and the standard deviation of the density distribution
m = mean2(gplot);
s = std2(gplot);
%now calculate the z score for each bin
zdensity = (gplot-m)./s;  %here the z score

%display probability plot
if syn~=0    %synapse number probability cal turned on
    if syn==1   %special case, pop up user dialogue
        syn = str2double(response_box('title','Enter the synapse number','input','0','position','center'));
    end
    pplot = (gdata/syn)./gvol;  %creat the probability array half
else                %total puncta number probability cal
    pplot = (gdata/size(data,1))./gvol;  %creat the probability array half
end
pplot = horzcat(pplot,fliplr(pplot(:,1:r+1)));
gyro.pplot = pplot;

%--------------------------------------------------------------------------
%bin noramlization clipping calculation, returns a percent clipped value
%based in spheres in x y and z
function [clip_per] = normclip(d,r)
%d = dimension (or number of slices)
%r = radius
clip_per = 0;   %initialize
%calculate sphere first.
base_s = (4/3).*pi.*r.^3;
%cycle through each slice
for i = 1:d
    h1 = r-i;    %the height of the clipping
    h1(h1<0) = 0;     %zero it out no negatives
    fclip = ((pi.*h1.^2)./3).*(3.*r-h1);
    h2 = r-(d-i);    %the height of the clipping
    h2(h2<0) = 0;
    bclip = ((pi.*h2.^2)./3).*(3.*r-h2);
    %now calculate the percent clipped
    clip_tmp = ((fclip+bclip)./base_s)./d;    %the volume contribution of this slice in percent
    clip_per = clip_per+clip_tmp;
end
%--------------------------------------------------------------------------
%a little function to select a volume edge irregardless
function [sel_vol] = select_vol(data,x,y)
try     %defualt
    sel_vol = data(x-1:x+1,y-1:y+1);
catch
    %now try to find a working selection
    try
        sel_vol = data(x:x+1,y-1:y+1);
    catch
        try
            sel_vol = data(x-1:x,y-1:y+1);
        catch
            try
                sel_vol = data(x-1:x+1,y:y+1);
            catch
                sel_vol = data(x-1:x+1,y-1:y);
            end
        end
    end
end